/*******************************************************
{                                                       }
{       RichView & Addict3                              }
{       The simplest demo.                              }
{                                                       }
{       TRichview (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{       Addict3 (c) Addictive Software                  }
{       addictsw@addictivesoftware.com                  }
{       http://www.addictivesoftware.com                }
{                                                       }
********************************************************/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainFrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ad3RichViewCmpnts"
#pragma link "ad3Spell"
#pragma link "ad3SpellBase"
#pragma link "RichView"
#pragma link "RVEdit"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNLATag(
    "Speling contest - a kontest in wich you are elimineited if you fale to spel a vord corectly.", 0,0,0);
  RichViewEdit1->Format();
  RichViewEdit1->StartLiveSpelling();
  // remove this line for CB4
  PopupMenu1->AutoHotkeys = maManual;
}
//---------------------------------------------------------------------------
// Spelling dialog
void __fastcall TfrmMain::Button1Click(TObject *Sender)
{
  RVAddictSpell31->CheckRichViewEdit(RichViewEdit1, ctSmart);
}
//---------------------------------------------------------------------------
// Live spelling check
void __fastcall TfrmMain::RichViewEdit1SpellingCheck(
      TCustomRichView *Sender, const AnsiString AWord, int StyleNo,
      bool &Misspelled)
{
  Misspelled = ! RVAddictSpell31->WordAcceptable(AWord);
}
//---------------------------------------------------------------------------
// Ignore All
void __fastcall TfrmMain::RVAddictSpell31ParserIgnoreWord(TObject *Sender,
      bool Before, int State)
{
  if (!Before &&
      (State == IgnoreState_IgnoreAll || State == IgnoreState_Add))
    RichViewEdit1->LiveSpellingValidateWord(RVAddictSpell31->CurrentWord);
}
//---------------------------------------------------------------------------
// Before displaying the popup menu, we fill it with suggestions for the
// misspelled word. The clicked misspelled word is selected
// (alternatively, you can select it immediately before the replacement
// in PopupMenuItemClick)
void __fastcall TfrmMain::PopupMenu1Popup(TObject *Sender)
{
  AnsiString wrd;
  int stl;
  TMenuItem *mi;

  while (PopupMenu1->Items->Count)
    delete PopupMenu1->Items->Items[0];

  if (RichViewEdit1->GetCurrentMisspelling(true, wrd, stl))
  {
    TStringList * sl = new TStringList;
    RVAddictSpell31->Suggest(wrd, sl);
    for (int i = 0; i<sl->Count; i++)
    {
      mi = new TMenuItem(PopupMenu1);
      mi->Caption = sl->Strings[i];
      mi->OnClick = PopupMenuItemClick;
      PopupMenu1->Items->Add(mi);
    }
    if (sl->Count == 0)
    {
      mi = new TMenuItem(PopupMenu1);
      mi->Caption = "(no suggestions)";
      mi->Enabled = false;
      PopupMenu1->Items->Add(mi);
    }

    mi = new TMenuItem(PopupMenu1);
    mi->Caption = "-";
    PopupMenu1->Items->Add(mi);

    mi = new TMenuItem(PopupMenu1);
    mi->Caption = "&Add to Dictionary";
    mi->OnClick = PopupMenuAddToDictionaryClick;
    PopupMenu1->Items->Add(mi);

    mi = new TMenuItem(PopupMenu1);
    mi->Caption = "&Ignore All";
    mi->OnClick = PopupMenuIgnoreAllClick;
    PopupMenu1->Items->Add(mi);

    delete sl;
  }
}
//---------------------------------------------------------------------------
// Clicking menu item - menu caption replaces the selected text
void __fastcall TfrmMain::PopupMenuItemClick(TObject *Sender)
{
  /*
    The text is already selected in PopupMenu1Popup by calling
    GetCurrentMisspelling(True,...).
    If you do not want to select misspelled word when displaing the menu,
    call GetCurrentMisspelling(False,...) there, and call
    GetCurrentMisspelling(True,...) here.
    The same is for other PopupMenu*** procedures.
  */

  // Make sure that "&" were not added to menu items
  // (PopupMenu1->AutoHotkeys must be maManual)
  RichViewEdit1->InsertText(((TMenuItem*)Sender)->Caption, false);
}
//---------------------------------------------------------------------------
// Clicking "Add to Dictionary"
void __fastcall TfrmMain::PopupMenuAddToDictionaryClick(TObject *Sender)
{
  AnsiString s = RichViewEdit1->GetSelText();
  RVAddictSpell31->AddToDictionary(s);
  RichViewEdit1->LiveSpellingValidateWord(s);
}
//---------------------------------------------------------------------------
// Clicking "Ignore All"
void __fastcall TfrmMain::PopupMenuIgnoreAllClick(TObject *Sender)
{
  AnsiString s = RichViewEdit1->GetSelText();
  RVAddictSpell31->AddToIgnoreList(s);
  RichViewEdit1->LiveSpellingValidateWord(s);
}
//---------------------------------------------------------------------------
// Autocorrection procedure. You can copy it in your application
bool AutoCorrect(TCustomRichViewEdit* rve, TRVAddictSpell3* rvad3)
{
  rve = rve->TopLevelEditor;
  int ItemNo  = rve->CurItemNo;
  if (rve->GetItemStyle(ItemNo)<0 ||
      rve->Style->TextStyles->Items[rve->GetItemStyle(ItemNo)]->Charset==SYMBOL_CHARSET)
    return false;
  TRVCodePage CodePage = rve->RVData->GetItemCodePage(ItemNo);
  AnsiString s = rve->GetItemTextA(ItemNo);
  int WordEnd = rve->OffsetInCurItem;
  int WordStart = WordEnd;
  if (WordStart<1)
    return false;
  while (WordStart-1>0 && !rve->RVData->IsDelimiterA(s[WordStart-1], CodePage))
    WordStart--;
  s = s.SubString(WordStart, WordEnd-WordStart);
  AnsiString s2;
  if (rvad3->WordHasCorrection(s,s2))
  {
    rve->SetSelectionBounds(ItemNo, WordStart, ItemNo, WordEnd);
    rve->InsertText(s2, false);
    return true;
  }
  return false;
}
//---------------------------------------------------------------------------
// autocorrection on typing: make sure that autocorrect.adu is installed and
// checked in the options dialog
void __fastcall TfrmMain::RichViewEdit1KeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  switch (Key)
  {
    case VK_SPACE:
    case VK_RETURN:
    case VK_TAB:
      AutoCorrect(RichViewEdit1, RVAddictSpell31);
  }
}
//---------------------------------------------------------------------------
