{*******************************************************}
{                                                       }
{       TRichView & Addict4                             }
{                                                       }
{       TRichview (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{       Addict4 (c) Addictive Software                  }
{       addictsw@addictivesoftware.com                  }
{       http://www.addictivesoftware.com                }
{                                                       }
{*******************************************************}

unit Unit1;

interface

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, RVStyle, RVScroll, RichView, RVEdit, StdCtrls, Menus,
  ad3ParserBase, ad3SpellBase, ad3Spell, ad3RichViewCmpnts,
  ad3ThesaurusBase, ad3Thesaurus, RVTypes;

type
  TForm1 = class(TForm)
    RichViewEdit1: TRichViewEdit;
    RVStyle1: TRVStyle;
    Button1: TButton;
    PopupMenu1: TPopupMenu;
    RVThesaurus31: TRVThesaurus3;
    RVAddictSpell31: TRVAddictSpell3;
    procedure FormCreate(Sender: TObject);
    procedure RichViewEdit1SpellingCheck(Sender: TCustomRichView;
      const AWord: String; StyleNo: Integer; var Misspelled: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure RVAddictSpell31ParserIgnoreWord(Sender: TObject; Before: Boolean;
      State: Integer);
    procedure RichViewEdit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RichViewEdit1RVDblClick(Sender: TCustomRichView;
      ClickedWord: TRVRawByteString; Style: Integer);
  private
    { Private declarations }
    procedure PopupMenuItemClick(Sender: TObject);
    procedure PopupMenuAddToDictionaryClick(Sender: TObject);
    procedure PopupMenuIgnoreAllClick(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
  RichViewEdit1.Clear;
  RichViewEdit1.AddNL
    ('Speling contest - a kontest in wich you are elimineited if you fale to spel a vord corectly.',
    0, 0);
  RichViewEdit1.Format;
  RichViewEdit1.StartLiveSpelling;
  PopupMenu1.AutoHotkeys := maManual;
end;

{------------------------------------------------------------------------------}
// Spelling dialog
procedure TForm1.Button1Click(Sender: TObject);
begin
  RVAddictSpell31.CheckRichViewEdit(RichViewEdit1, ctSmart);
end;

{------------------------------------------------------------------------------}
// Live spelling
procedure TForm1.RichViewEdit1SpellingCheck(Sender: TCustomRichView;
  const AWord: String; StyleNo: Integer; var Misspelled: Boolean);
begin
  Misspelled := not RVAddictSpell31.WordAcceptable(AWord);
end;

{------------------------------------------------------------------------------}
// Ignore All
procedure TForm1.RVAddictSpell31ParserIgnoreWord(Sender: TObject;
  Before: Boolean; State: Integer);
begin
  if not Before and (State in [IgnoreState_IgnoreAll, IgnoreState_Add]) then
    RichViewEdit1.LiveSpellingValidateWord(RVAddictSpell31.CurrentWord);
end;

{------------------------------------------------------------------------------}
// Before displaying the popup menu, we fill it with suggestions for the
// misspelled word. The clicked misspelled word is selected
// (alternatively, you can select it immediately before the replacement
// in PopupMenuItemClick)
procedure TForm1.PopupMenu1Popup(Sender: TObject);
var
  wrd:    String;
  stl, i: Integer;
  sl:     TStringList;
  mi:     TMenuItem;
begin
  while PopupMenu1.Items.Count > 0 do
    PopupMenu1.Items[0].Free;
  if RichViewEdit1.GetCurrentMisspelling(True, wrd, stl) then
  begin
    sl := TStringList.Create;
    RVAddictSpell31.Suggest(wrd, sl);
    for i := 0 to sl.Count - 1 do
    begin
      mi := TMenuItem.Create(PopupMenu1);
      mi.Caption := sl[i];
      mi.OnClick := PopupMenuItemClick;
      PopupMenu1.Items.Add(mi);
    end;
    if sl.Count = 0 then
    begin
      mi := TMenuItem.Create(PopupMenu1);
      mi.Caption := '(no suggestions)';
      mi.Enabled := False;
      PopupMenu1.Items.Add(mi);
    end;

    mi := TMenuItem.Create(PopupMenu1);
    mi.Caption := '-';
    PopupMenu1.Items.Add(mi);

    mi := TMenuItem.Create(PopupMenu1);
    mi.Caption := '&Add to Dictionary';
    mi.OnClick := PopupMenuAddToDictionaryClick;
    PopupMenu1.Items.Add(mi);

    mi := TMenuItem.Create(PopupMenu1);
    mi.Caption := '&Ignore All';
    mi.OnClick := PopupMenuIgnoreAllClick;
    PopupMenu1.Items.Add(mi);

    sl.Free;
  end;
end;

{------------------------------------------------------------------------------}
// Clicking menu item - menu caption replaces the selected text
procedure TForm1.PopupMenuItemClick(Sender: TObject);
begin
  {
   The text is already selected in PopupMenu1Popup by calling
   GetCurrentMisspelling(True,...).
   If you do not want to select misspelled word when displaing the menu,
   call GetCurrentMisspelling(False,...) there, and call
   GetCurrentMisspelling(True,...) here.
   The same is for other PopupMenu*** procedures.
  }
  RichViewEdit1.InsertText((Sender as TMenuItem).Caption);
end;

{------------------------------------------------------------------------------}
// Clicking "Add to Dictionary"
procedure TForm1.PopupMenuAddToDictionaryClick(Sender: TObject);
var
  s: String;
begin
  s := RichViewEdit1.GetSelText;
  RVAddictSpell31.AddToDictionary(s);
  RichViewEdit1.LiveSpellingValidateWord(s);
end;

{------------------------------------------------------------------------------}
// Clicking "Ignore All"
procedure TForm1.PopupMenuIgnoreAllClick(Sender: TObject);
var
  s: String;
begin
  s := RichViewEdit1.GetSelText;
  RVAddictSpell31.AddToIgnoreList(s);
  RichViewEdit1.LiveSpellingValidateWord(s);
end;

{------------------------------------------------------------------------------}
// Autocorrection procedure. You can copy it in your application
function AutoCorrect(rve: TCustomRichViewEdit; rvad3: TRVAddictSpell3): Boolean;
var
  ItemNo, WordEnd, WordStart: Integer;
  s, s2:                      String;
  {$IFNDEF RVUNICODESTR} // <- Defined for Delphi 2009+
  CodePage: TRVCodePage;
  {$ENDIF}
begin
  Result := False;
  rve := rve.TopLevelEditor;
  ItemNo := rve.CurItemNo;
  WordEnd := rve.OffsetInCurItem;
  {$IFNDEF RVUNICODESTR}
  CodePage := rve.RVData.GetItemCodePage(ItemNo);
  {$ENDIF}
  if (rve.GetItemStyle(ItemNo) < 0) or
    (rve.Style.TextStyles[rve.GetItemStyle(ItemNo)].Charset = SYMBOL_CHARSET)
  then
    exit;
  s := rve.GetItemText(ItemNo);
  WordStart := WordEnd;
  if WordStart < 1 then
    exit;
  while (WordStart - 1 > 0) and not
  {$IFDEF RVUNICODESTR}
    rve.RVData.IsDelimiterW(s[WordStart - 1])
  {$ELSE}
    rve.RVData.IsDelimiterA(s[WordStart - 1], CodePage)
  {$ENDIF}
    do
    dec(WordStart);
  s := Copy(s, WordStart, WordEnd - WordStart);
  Result := rvad3.WordHasCorrection(s, s2);
  if Result then
  begin
    rve.SetSelectionBounds(ItemNo, WordStart, ItemNo, WordEnd);
    rve.InsertText(s2);
  end;
end;

{------------------------------------------------------------------------------}
// autocorrection on typing: make sure that autocorrect.adu is installed and
// checked in the options dialog
procedure TForm1.RichViewEdit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key in [VK_SPACE, VK_RETURN, VK_TAB] then
    AutoCorrect(RichViewEdit1, RVAddictSpell31);
end;

{------------------------------------------------------------------------------}
// Double click to show thesaurus
procedure TForm1.RichViewEdit1RVDblClick(Sender: TCustomRichView;
  ClickedWord: TRVRawByteString; Style: Integer);
begin
  RVThesaurus31.LookupRichViewEdit(RichViewEdit1);
end;

end.
