(*************************************************************

 Addict,   Addictive Software
 Contact: support@addictivesoftware.com

 Components for parsing TCustomRichViewEdit:
 TRVAddictSpell3

 History:
 mm/dd/yy
 01/09/08     - when custom dictionary is not selected (ActiveCustomDictionary=nil),
 AddToDictionary beeps (instead of exception) 
 09/25/05     - SelectWord property for thesaurus
 10/06/04     - AddToDictionary and AddToIgnoreList methods
 01/31/02     - Spell checking Unicode
 09/29/01     - Update for RichView 1.5.19
 CheckRichViewEdit now can spellcheck text in
 tables.
 Older method is renamed to FastCheckRichViewEdit.
 This method is faster, but cannot spellcheck tables
 (when called from inside table cell, it spellchecks
 this cell only)
 06/30/01     - Update for RichView 1.5.4
 01/08/01     - Initial write

 **************************************************************)

unit ad3RichViewCmpnts;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ad3SpellBase, ad3Spell, ad3Thesaurus,
  RVEdit, ad3RichView, ad3RichViewFast, RVStyle;

type
  TRVAddictSpell3 = class(TAddictSpell3)
  private
    FCodePage: TRVCodePage;
  protected
    procedure Form_OnDeactivate(Sender: TObject); override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure CheckRichViewEdit(Control: TCustomRichViewEdit;
      CheckType: TCheckType);
    procedure FastCheckRichViewEdit(Control: TCustomRichViewEdit;
      CheckType: TCheckType);
    procedure AddToDictionary(const Word: String);
    procedure AddToIgnoreList(const Word: String);
  published
    property CodePage: TRVCodePage read FCodePage write FCodePage;
  end;

  TRVThesaurus3 = class(TThesaurus3)
  private
    FCodePage:   TRVCodePage;
    FSelectWord: Boolean;
  public
    constructor Create(AOwner: TComponent); override;
    procedure LookupRichViewEdit(Control: TCustomRichViewEdit);
    procedure FastLookupRichViewEdit(Control: TCustomRichViewEdit);
  published
    property CodePage:   TRVCodePage read FCodePage write FCodePage;
    property SelectWord: Boolean read FSelectWord write FSelectWord
      default False;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Addict', [TRVAddictSpell3, TRVThesaurus3]);
end;

{============================ TRVAddictSpell3 =================================}
constructor TRVAddictSpell3.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCodePage := CP_ACP;
end;

{------------------------------------------------------------------------------}
procedure TRVAddictSpell3.Form_OnDeactivate(Sender: TObject);
begin
  inherited;
  if (FParser <> nil) and (FParser is TRichViewParser3) then
    TRichViewParser3(FParser).Cleanup;
end;

{------------------------------------------------------------------------------}
procedure TRVAddictSpell3.CheckRichViewEdit(Control: TCustomRichViewEdit;
  CheckType: TCheckType);
var
  Parser: TRichViewParser3;
begin
  Parser := TRichViewParser3.Create;
  Parser.CodePage := CodePage;
  Parser.Initialize(Control);

  CheckParser(Parser, CheckType);

  if (not FFreeParser) then
  begin
    Parser.Free;
  end;
End;

procedure TRVAddictSpell3.FastCheckRichViewEdit(Control: TCustomRichViewEdit;
  CheckType: TCheckType);
var
  Parser: TFastRichViewParser3;
begin
  while Control.InplaceEditor <> nil do
    Control := Control.InplaceEditor as TCustomRichViewEdit;
  Parser := TFastRichViewParser3.Create;
  Parser.CodePage := CodePage;
  Parser.Initialize(Control);

  CheckParser(Parser, CheckType);

  if (not FFreeParser) then
  begin
    Parser.Free;
  end;
End;

procedure TRVAddictSpell3.AddToDictionary(const Word: String);
begin
  if ActiveCustomDictionary <> nil then
    ActiveCustomDictionary.AddIgnore(Word)
  else
    Beep;
end;

procedure TRVAddictSpell3.AddToIgnoreList(const Word: String);
begin
  InternalCustom.AddIgnore(Word);
end;

{================================== TRVThesaurus3 =============================}
constructor TRVThesaurus3.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCodePage := CP_ACP;
end;

{------------------------------------------------------------------------------}
procedure TRVThesaurus3.LookupRichViewEdit(Control: TCustomRichViewEdit);
var
  Parser: TRichViewParser3;
begin
  Parser := TRichViewParser3.Create;
  Parser.CodePage := CodePage;
  Parser.SelectChangedWord := SelectWord;
  Parser.Initialize(Control);
  LookupParser(Parser);
  Parser.Free;
end;

procedure TRVThesaurus3.FastLookupRichViewEdit(Control: TCustomRichViewEdit);
var
  Parser: TFastRichViewParser3;
begin
  Parser := TFastRichViewParser3.Create;
  Parser.CodePage := CodePage;
  Parser.SelectChangedWord := SelectWord;
  while Control.InplaceEditor <> nil do
    Control := Control.InplaceEditor as TCustomRichViewEdit;
  Parser.Initialize(Control);
  LookupParser(Parser);
  Parser.Free;
end;

end.
