(*************************************************************

 Addict (c) Addictive Software
 Contact: addictsw@kagi.com

 TRichView (c) Sergey Tkachenko
 Contact: svt@trichview.com

 TCustomRichViewEdit (11.0+) parser for Addict 3 and 4

 History:
 2011-Mar-18 - Skipping hidden text when checking
 2009-Jan-16 - Compatibility with D2009 and Addict 4
 2007-Sep-09 - RVDONOTUSEUNICODE compiler define is supported.
 2005-Sep-25 - Fix in thesaurus word repaint. SelectChangedWord.
 2004-Aug-27 - Fix
 2004-Aug-15 - Different method of text replacing
 2002-Jan-31 - Spell checking Unicode
 2001-Sep-29 - Update for RichView 1.5.19 (renamed from ad3RichView)
 2001-Jun-30 - Update for RichView 1.5.4
 2001-Aug-01 - Initial Write

 **************************************************************)

unit ad3RichViewFast;

{$I addict3.inc}
{$I RV_Defs.inc}

interface

uses
  windows, sysutils, classes, controls, messages,
  ad3ParserBase, RichView, RVEdit, RVStyle, RVItem, RVUni, RVTypes, RVScroll,
  CRVData, RVRVData;

type

  TFastRichViewParser3 = class(TControlParser)

  protected

    FCodePage:                            TRVCodePage;
    FEdit:                                TCustomRichViewEdit;
    FItemNo, FOffs, FEndItemNo, FEndOffs: Integer;
    FUsingEnd:                            Boolean;

    FLine:       String;
    FLineIndex:  LongInt;
    FLineLength: Integer;
    FDirty:      Boolean;

    FSelectChangedWord: Boolean;

  protected

    function EnsureLineCurrent: Boolean; virtual;
    function CanCheckItem(ItemNo: Integer): Boolean;

  public
    procedure Initialize(EditControl: Pointer); override;
    function GetChar: char; override;
    function GetLine: String; override;
    function MoveNext: Boolean; override;
    function MovePrevious: Boolean; override;
    procedure SetPosition(XPos: LongInt; YPos: LongInt;
      PosType: TPositionType); override;
    procedure GetPosition(var XPos: LongInt; var YPos: LongInt); override;
    procedure SelectWord(Length: LongInt); override;
    procedure ReplaceWord(Replacement: String; State: LongInt); override;
    procedure IgnoreWord(State: LongInt); override;
    procedure CenterSelection; override;
    procedure GetCursorPosition(var XPos: LongInt; var YPos: LongInt); override;
    procedure GetSelectionPosition(var XPosStart: LongInt;
      var YPosStart: LongInt; var XPosEnd: LongInt;
      var YPosEnd: LongInt); override;
    procedure GetControlScreenPosition(var ControlPosition: TRect); override;
    procedure GetSelectionScreenPosition(var SelectionPosition: TRect);
      override;
    procedure UndoLast(UndoState: LongInt; UndoAction: LongInt;
      var UndoData: LongInt); override;
    property CodePage: TRVCodePage write FCodePage;
    property SelectChangedWord: Boolean write FSelectChangedWord;
  end;

implementation

{------------------------------------------------------------------------------}
// Converting text from internal representation to String
function ConvertItemTextToString(const ItemText: TRVRawByteString;
  UnicodeItem: Boolean; CodePage: Cardinal): String;
begin
  {$IFDEF RVUNICODESTR} // <-- declared in RV_Defs.inc
  // Delphi 2009+: String is Unicode
  if UnicodeItem then
    Result := RVU_RawUnicodeToWideString(ItemText)
  else
    Result := RVU_RawUnicodeToWideString(RVU_AnsiToUnicode(CodePage, ItemText));
  {$ELSE}
  // Delphi 4-2007: String is ANSI
  {$IFNDEF RVDONOTUSEUNICODE}
  if UnicodeItem then
    Result := RVU_UnicodeToAnsi(CodePage, ItemText)
  else
    {$ENDIF}
    Result := ItemText;
  {$ENDIF}
end;

// Converting text from String to internal representation
function ConvertStringToItemText(const Text: String; UnicodeItem: Boolean;
  CodePage: Cardinal): TRVRawByteString;
begin
  {$IFDEF RVUNICODESTR} // <-- declared in RV_Defs.inc
  if UnicodeItem then
    Result := RVU_GetRawUnicode(Text)
  else
    Result := TRVAnsiString(Text);
  {$ELSE}
  {$IFNDEF RVDONOTUSEUNICODE}
  if UnicodeItem then
    Result := RVU_AnsiToUnicode(CodePage, Text)
  else
    {$ENDIF}
    Result := Text;
  {$ENDIF}
end;

{------------------------------- Utility Functions ----------------------------}
function TFastRichViewParser3.CanCheckItem(ItemNo: Integer): Boolean;
var
  StyleNo: Integer;
begin
  StyleNo := FEdit.GetItemStyle(ItemNo);
  Result := (StyleNo >= 0) and (FEdit.Style.TextStyles[StyleNo].Charset <>
    SYMBOL_CHARSET) and not(rvprModifyProtect in FEdit.Style.TextStyles[StyleNo]
    .Protection);
  if Result and not(rvoShowHiddenText in FEdit.Options) then
    Result := not(rvteoHidden in FEdit.Style.TextStyles[StyleNo].Options);
end;

{------------------------------------------------------------------------------}
function TFastRichViewParser3.EnsureLineCurrent: Boolean;
var
  r: Boolean;
begin

  Result := True;
  r := True;

  // Auto-Skip to another line if needbe

  if (FItemNo = FLineIndex) then
  begin
    if (FOffs >= FLineLength) then
    begin
      inc(FItemNo);
      while (FItemNo < FEdit.ItemCount) and not CanCheckItem(FItemNo) do
        inc(FItemNo);
      FOffs := 0;
    end
    else if (FOffs < 0) then
    begin
      dec(FItemNo);
      while (FItemNo >= 0) and not CanCheckItem(FItemNo) do
        dec(FItemNo);
      FOffs := -1;
    end;
  end;
  if FItemNo < 0 then
  begin
    FItemNo := 0;
    FOffs := 0;
    r := False;
  end;
  while (FItemNo < FEdit.ItemCount) and not CanCheckItem(FItemNo) do
    inc(FItemNo);
  // Now fetch the new line if needbe

  if (FItemNo <> FLineIndex) or FDirty then
  begin
    Result := (FItemNo < FEdit.ItemCount) and (FItemNo >= 0);
    if (Result) then
    begin
      FDirty := False;
      FLine := ConvertItemTextToString(FEdit.RVData.GetItemTextR(FItemNo),
        {$IFNDEF RVDONOTUSEUNICODE}
        rvioUnicode in FEdit.RVData.GetItem(FItemNo).ItemOptions,
        {$ELSE}
        False,
        {$ENDIF}
        FCodePage) + #13#10;
      FLineLength := Length(FLine);
      FLineIndex := FItemNo;
      if (FOffs = -1) then
        FOffs := FLineLength - 1;
    end;
  end;
  Result := Result and r;
end;

{-------------------------- TControlParser Implementation ---------------------}
procedure TFastRichViewParser3.Initialize(EditControl: Pointer);
begin
  FEdit := TObject(EditControl) as TCustomRichViewEdit;
  FUsingEnd := False;
  FItemNo := 0;
  FOffs := 0;
  FDirty := True;
  FLineLength := 0;
  FLineIndex := -1;
  FLine := '';
end;

{------------------------------------------------------------------------------}
function TFastRichViewParser3.GetChar: char;
begin
  if (EnsureLineCurrent) then
    Result := FLine[FOffs + 1]
  else
    Result := #0;
end;

{------------------------------------------------------------------------------}
function TFastRichViewParser3.GetLine: String;
begin
  if (EnsureLineCurrent) then
    Result := FLine
  else
    Result := '';
end;

{------------------------------------------------------------------------------}
function TFastRichViewParser3.MoveNext: Boolean;
begin
  inc(FOffs);
  Result := EnsureLineCurrent;
  if FUsingEnd and ((FItemNo > FEndItemNo) or ((FOffs > FEndOffs) and
    (FItemNo = FEndItemNo))) then
    Result := False;
end;

{------------------------------------------------------------------------------}
function TFastRichViewParser3.MovePrevious: Boolean;
begin
  dec(FOffs);
  Result := EnsureLineCurrent;
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.SetPosition(XPos: LongInt; YPos: LongInt;
  PosType: TPositionType);
begin
  if (PosType = ptCurrent) then
  begin
    FDirty := True;
    FOffs := XPos;
    FItemNo := YPos;
  end
  else if (PosType = ptEnd) then
  begin
    FUsingEnd := True;
    FEndOffs := XPos;
    FEndItemNo := YPos;
  end;
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.GetPosition(var XPos: LongInt;
  var YPos: LongInt);
begin
  XPos := FOffs;
  YPos := FItemNo;
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.SelectWord(Length: LongInt);
begin
  dec(FOffs, Length);
  if FItemNo < 0 then
    FItemNo := 0;
  if FItemNo >= FEdit.ItemCount then
    FItemNo := FEdit.ItemCount - 1;
  if FEdit.GetItemStyle(FItemNo) < 0 then
  begin
    if FOffs < FEdit.GetOffsBeforeItem(FItemNo) then
      FOffs := FEdit.GetOffsBeforeItem(FItemNo);
    if FOffs > FEdit.GetOffsAfterItem(FItemNo) then
      FOffs := FEdit.GetOffsAfterItem(FItemNo);
    if FOffs + Length > FEdit.GetOffsAfterItem(FItemNo) then
      Length := FEdit.GetOffsAfterItem(FItemNo) - FOffs;
    FEdit.SetSelectionBounds(FItemNo, FOffs, FItemNo, FOffs + Length);
  end
  else
  begin
    if FOffs + 1 < FEdit.GetOffsBeforeItem(FItemNo) then
      FOffs := FEdit.GetOffsBeforeItem(FItemNo) - 1;
    if FOffs + 1 > FEdit.GetOffsAfterItem(FItemNo) then
      FOffs := FEdit.GetOffsAfterItem(FItemNo) - 1;
    if FOffs + Length + 1 > FEdit.GetOffsAfterItem(FItemNo) then
      Length := FEdit.GetOffsAfterItem(FItemNo) - FOffs - 1;
    FEdit.SetSelectionBounds(FItemNo, FOffs + 1, FItemNo, FOffs + Length + 1)
  end;
  FEdit.Invalidate;
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.ReplaceWord(Replacement: String; State: LongInt);
var
  StartItemNo, StartOffs, EndItemNo, EndOffs: Integer;
var
  s, rep: TRVRawByteString;
  ItemNo,
  {$IFNDEF RVDONOTUSEUNICODE}
  StyleNo,
  {$ENDIF}
  len, replen: Integer;
begin
  if (FUsingEnd) and (FItemNo = FEndItemNo) then
  begin
    FEdit.GetSelectionBounds(StartItemNo, StartOffs, EndItemNo, EndOffs, True);
    Assert((StartItemNo = EndItemNo) and (StartItemNo = FItemNo));
    inc(FEndOffs, Length(Replacement) - (EndOffs - StartOffs));
  end;
  // This code is used instead of InsertText to keep item properties
  len := Length(FEdit.GetSelText);
  ItemNo := FEdit.TopLevelEditor.CurItemNo;
  StyleNo := FEdit.TopLevelEditor.GetItemStyle(ItemNo);
  s := FEdit.GetCurrentItemTextR;
  rep := ConvertStringToItemText(Replacement,
    {$IFNDEF RVDONOTUSEUNICODE}
    FEdit.Style.TextStyles[StyleNo].Unicode,
    {$ELSE}
    False,
    {$ENDIF}
    FEdit.TopLevelEditor.RVData.GetStyleCodePage(StyleNo));
  {$IFNDEF RVDONOTUSEUNICODE}
  if FEdit.Style.TextStyles[StyleNo].Unicode then
  begin
    Delete(s, FOffs * 2 + 1, len * 2);
    Insert(rep, s, FOffs * 2 + 1);
    replen := Length(rep) div 2;
  end
  else
  {$ENDIF}
  begin
    Delete(s, FOffs + 1, len);
    Insert(rep, s, FOffs + 1);
    replen := Length(rep);
  end;
  FEdit.SetCurrentItemTextR(s);
  if FSelectChangedWord then
    FEdit.TopLevelEditor.SetSelectionBounds(ItemNo, FOffs + 1, ItemNo,
      FOffs + replen + 1)
  else
    FEdit.TopLevelEditor.SetSelectionBounds(ItemNo, FOffs + replen + 1, ItemNo,
      FOffs + replen + 1);
  FEdit.TopLevelEditor.Invalidate;
  // FEdit.InsertText(Replacement);
  inc(FOffs, replen);
  FDirty := True;
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.IgnoreWord(State: LongInt);
var
  A, B: Integer;
begin
  FEdit.GetSelectionBounds(A, B, FItemNo, FOffs, True);
  dec(FOffs);
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.CenterSelection;
begin

end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.GetCursorPosition(var XPos: LongInt;
  var YPos: LongInt);
begin
  YPos := FEdit.CurItemNo;
  XPos := FEdit.OffsetInCurItem;
  if FEdit.GetItemStyle(YPos) >= 0 then
    dec(XPos);
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.GetSelectionPosition(var XPosStart: LongInt;
  var YPosStart: LongInt; var XPosEnd: LongInt; var YPosEnd: LongInt);
begin
  FEdit.RVData.GetSelectionBoundsEx(YPosStart, XPosStart, YPosEnd,
    XPosEnd, True);
  if FEdit.GetItemStyle(YPosStart) >= 0 then
    dec(XPosStart);
  if FEdit.GetItemStyle(YPosEnd) >= 0 then
    dec(XPosEnd);
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.GetControlScreenPosition
  (var ControlPosition: TRect);
var
  P: TPoint;
begin
  P := Point(0, 0);
  P := FEdit.ClientToScreen(P);
  ControlPosition := Rect(P.X, P.Y, P.X + FEdit.Width, P.Y + FEdit.Height);
end;

{------------------------------------------------------------------------------}
procedure TFastRichViewParser3.GetSelectionScreenPosition
  (var SelectionPosition: TRect);
begin
  SelectionPosition := FEdit.GetSelectionRect;
end;

// ************************************************************

procedure TFastRichViewParser3.UndoLast(UndoState: LongInt; UndoAction: LongInt;
  var UndoData: LongInt);
begin

end;

// ************************************************************

end.
